# The TanvasTouch C API example program

This program is a C implementation of the Hello Tanvas program described at
https://tanvas.co/resources/api-reference/tanvastouch/dotnet-interface/articles/hello-tanvas.html.
It has been tested in the following environments:

| OS            | Compiler       |
| ------------- | -------------- |
| Windows 10    | MSVC 2019 16.6 |
| Kubuntu 20.04 | clang 10.0.0   |
| Kubuntu 20.04 | gcc 9.3.0      |

Any recent C compiler should be able to build the program.  If you find this is not the case,
contact support@tanvas.co.

## Installing dependencies on Windows

This example requires TanvasTouch Windows SDK v3.0.0 or later.  You can download SDK v3.0.0 from
https://tanvas.co/resources/tanvas-downloads.

This example contains a copy of the TanvasTouch C API library from SDK v3.0.0 in
`external\tanvastouch`.
If you have a newer version of the TanvasTouch Windows SDK installed, you can copy the contents of
`TanvasTouch SDK\API\C` into that directory.

The TanvasTouch C API example program has additional dependencies on [SDL](https://libsdl.org/) and
[stb_image](https://github.com/nothings/stb).  Tanvas recommends using the
[Vcpkg package manager](https://github.com/microsoft/vcpkg) to install these dependencies.

To install dependencies via Vcpkg, follow the instructions at
https://github.com/microsoft/vcpkg/blob/master/README.md#quick-start-windows to install Vcpkg.
Then, in the Vcpkg directory, run

```
vcpkg integrate install
```

This command will output a path to a `vcpkg.cmake` file.  Make a note of this path for later
reference.

Next, run

```
vcpkg install sdl2 stb --triplet x64-windows
```

## Building the program with Visual Studio 2019

To build this program with Visual Studio 2019, select **File > Open > CMake...** and select the
directory containing this README file.  If you are at the Visual Studio 2019 startup screen, select
**Open a local folder** and select the directory containing this README file.

If **File > Open > CMake...** is not available, you may need to install additional Visual Studio
components.  In Visual Studio Installer, select **Modify** > **Individual components** and make sure
that **C++ CMake tools for Windows** is checked.

With Visual Studio 2019, the `vcpkg integrate install` command you ran in the "Installing
dependencies on Windows" section should allow Visual Studio to automatically detect Vcpkg.  If it
does not, you can supply the path to `vcpkg.cmake` in the **CMake toolchain file** field in Visual
Studio's CMake Settings dialog.

## Running the program in Visual Studio 2019

Make sure that the TanvasTouch Engine is running.  Afterwards, press the Start button in Visual
Studio or select **Debug > Start Debugging**.

If you see **Select Startup Item...** in Visual Studio, press the down arrow next to the **Select
Startup Item...** text and select **tanvastouch-c-api-example.exe**.

## Building the program from the command line

This program can also be built from the command line using CMake:

```
mkdir build
cd build
cmake -DCMAKE_TOOLCHAIN_FILE=[vcpkg.cmake path] ..
cmake --build .
```

The text `[vcpkg.cmake path]` should be replaced by the path printed out by `vcpkg integrate
install`.

## Structure of the program

The program is split into the following parts:

| File        | Purpose                                          |
| ----------  | ------------------------------------------------ |
| haptics.c   | API context management and haptic scene creation |
| load_png.c  | PNG loader                                       |
| main.c      | Startup code and main loop                       |
| stb_image.c | Implementation file for stb_image                |
| visuals.c   | Functions to create SDL surfaces from PNGs       |

## Using the TanvasTouch C API in C++ programs

The TanvasTouch C API can be used as-is in C++ programs, or it can be wrapped with C++ constructs to
relieve the programmer of manual tasks.  For more information on this subject, please read the
`cpp_wrappers.md` document in the `docs` directory.
