/***************************************************************************************************
 *
 *  Tanvas, Inc
 *  https://tanvas.co
 *
 *  Copyright(c) 2021. All Rights Reserved
 *
 *  Source code from Tanvas is supplied under the terms of a license agreement
 *  and may not be copied or disclosed except in accordance with the terms of that agreement.
 *  The various license agreements may be found at the Tanvas web site.
 *
 **************************************************************************************************/

#include "visuals.h"

SDL_Surface* image_to_sdl_surface(image img)
{
	Uint32 rmask, gmask, bmask;

#if SDL_BYTEORDER == SDL_BIG_ENDIAN
	rmask = 0xff000000;
	gmask = 0x00ff0000;
	bmask = 0x0000ff00;
#else
	rmask = 0x000000ff;
	gmask = 0x0000ff00;
	bmask = 0x00ff0000;
#endif

	SDL_Surface* surface = SDL_CreateRGBSurfaceFrom(img.data, img.width, img.height, 24,
	                                                3 * img.width, rmask, gmask, bmask, 0);

	if (surface == NULL) {
		SDL_LogError(SDL_LOG_CATEGORY_ERROR, "Failed to create SDL surface: %s", SDL_GetError());
	}

	return surface;
}
