/***************************************************************************************************
 *
 *  Tanvas, Inc
 *  https://tanvas.co
 *
 *  Copyright(c) 2021. All Rights Reserved
 *
 *  Source code from Tanvas is supplied under the terms of a license agreement
 *  and may not be copied or disclosed except in accordance with the terms of that agreement.
 *  The various license agreements may be found at the Tanvas web site.
 *
 **************************************************************************************************/

#ifndef TANVAS_TANVASTOUCH_C_API_EXAMPLE_HAPTICS_H
#define TANVAS_TANVASTOUCH_C_API_EXAMPLE_HAPTICS_H

#include <tanvas/tanvastouch.h>

/**
 * Open a connection to a TanvasTouch Engine.  Assumes the default engine name.
 *
 * Returns the connection context on success, NULL on failure.  Errors are logged using
 * the SDL log functions.
 */
tanvastouch_ctx* connect_to_engine();

/**
 * Creates the haptic scene for the C API example.
 *
 * Returns the ID of the top-level view.  Errors are logged using the SDL log functions.
 */
tanvastouch_resource_id create_haptic_scene(tanvastouch_ctx* ctx);

#endif /* #ifndef TANVAS_TANVASTOUCH_C_API_EXAMPLE_HAPTICS_H */