/***************************************************************************************************
 *
 *  Tanvas, Inc
 *  https://tanvas.co
 *
 *  Copyright(c) 2021. All Rights Reserved
 *
 *  Source code from Tanvas is supplied under the terms of a license agreement
 *  and may not be copied or disclosed except in accordance with the terms of that agreement.
 *  The various license agreements may be found at the Tanvas web site.
 *
 **************************************************************************************************/

#include "load_png.h"
#include <SDL.h>
#include <stb_image.h>

int load_rgb_png(const char* filename, int requested_format, image* img)
{
	int format;

	if (!(requested_format == STBI_rgb || requested_format == STBI_grey)) {
		SDL_LogError(SDL_LOG_CATEGORY_ERROR, "Unsupported format %d", requested_format);
		return 0;
	}

	img->data = stbi_load(filename, &img->width, &img->height, &format, requested_format);

	if (img->data == NULL) {
		SDL_LogError(SDL_LOG_CATEGORY_ERROR, "Could not load image %s: %s", filename,
		             stbi_failure_reason());
		return 0;
	}

	return 1;
}

void free_rgb_png(image* img)
{
	stbi_image_free(img->data);
}
