/***************************************************************************************************
 *
 *  Tanvas, Inc
 *  https://tanvas.co
 *
 *  Copyright(c) 2021. All Rights Reserved
 *
 *  Source code from Tanvas is supplied under the terms of a license agreement
 *  and may not be copied or disclosed except in accordance with the terms of that agreement.
 *  The various license agreements may be found at the Tanvas web site.
 *
 **************************************************************************************************/

#ifndef TANVAS_LOAD_PNG_H
#define TANVAS_LOAD_PNG_H

#include <stb_image.h>

typedef struct {
	unsigned char* data;
	int width;
	int height;
} image;

/**
 * Load a PNG with the given filename using stbi_load.
 *
 * requested_format is a format specifier from stb_image, e.g. STBI_rgb.  Currently,
 * only STBI_rgb and STBI_grey are supported.  The format of the image data pointed
 * to by img->data is determined by this format.
 *
 * Returns 1 on success, 0 on failure.  Error messages are logged by SDL_log.
 *
 * You should always call free_rgb_png on img once you are done with the image data,
 * even on a failed call to load_rgb_png.
 */
int load_rgb_png(const char* filename, int requested_format, image* img);

/**
 * Frees image data in img.  If img->data is NULL, does nothing.
 */
void free_rgb_png(image* img);

#endif /* #ifndef TANVAS_LOAD_PNG_H */
